#include "StdAfx.h"
#include "DllCustomDll.h"
#include "DllManagerCustomDll.h"
#include "ServiceSPCCustomDll.h"
//////////////////////////////////////////////////////////////////////////////////////////
CServiceSPCCustomDll::CServiceSPCCustomDll(CDllManager* iDllManager):CServiceSPC(iDllManager){
	 mClassName="CServiceSPCCustomDll";
	 // Define new Command AT+CSTM=<n>
	 CList<StructParam,StructParam&>* structParamListCSTM=new CList<StructParam,StructParam&>;
	 // Define param "n" : name, type, group, default string value, default int value, default bool value, default double value, range, true is this param is repeated
	 StructParam sPn={"n",TYPE_INT,0,"",-1,FALSE,0,"0-10",FALSE};
	 structParamListCSTM->AddTail(sPn);
	 // define the cmd : prefix, name, cmdID, serviceID, serviceName, type, true if cmd needs phone to be in ready state, true if cmd needs phone to be nwk registered, level of phone functionnality needed, NULL, paramList setted below
	 StructAT sATCSTM={"AT","+CSTM",52,SERVICE_SPC,"CServiceSPCCustomDll",SET_TYPE|GET_TYPE|LIST_TYPE,FALSE,FALSE,0,NULL,NULL};
	 sATCSTM.mStructParamList=structParamListCSTM;
	 // Add this command to this service
	 AddCmd(sATCSTM);

	 // Register this service to be notified on ConfigSPC changes
	CConfigSPCCustomDll* cfgSPC=(CConfigSPCCustomDll*)GetConfig(CONFIG_SPC);
	cfgSPC->AddListener(this);

}
//////////////////////////////////////////////////////////////////////////////////////////
CServiceSPCCustomDll::~CServiceSPCCustomDll() 
{
}
//////////////////////////////////////////////////////////////////////////////////////////
Bool CServiceSPCCustomDll::CSTM(CCmd* iCmdP, bool iSilentMode)
{
	// Get back the param
	int paramN=iCmdP->GetParam("n")->GetValueInt();
	// Get a pointer on the config we need
	CConfigSPCCustomDll* cfg=(CConfigSPCCustomDll*)GetConfig(CONFIG_SPC);
	CString buf;
	switch(iCmdP->GetCurrentType())
		{
		case SET_TYPE :
			buf.Format("Set CSTM cmd with value %d",paramN);
			AppendVPMsg(buf);
			cfg->SetParamN(paramN);			
		break;
		case GET_TYPE:
			buf.Format("Return current paramN value",paramN);
			AppendVPMsg(buf);
			buf.Format("+CSTM: %d",cfg->GetParamN());			
			FormatATMsg(buf,iCmdP,iSilentMode);
		break;
		case LIST_TYPE:						
			CString range=iCmdP->GetParam("n")->GetRangeDefinition();
			range.Replace("-",",");
			buf.Format("+CSTM: (%s)\r\n",range);
			FormatATMsg(buf,iCmdP,iSilentMode);
		break;
		}
	FormatATOK(iCmdP,iSilentMode);
	return true;
}
//////////////////////////////////////////////////////////////////////////////////////////
Bool CServiceSPCCustomDll::Dispatch(CCmd* iCmdP) {
	 mCS.Lock();
	StartExecutingCmd();	
	Bool result=false;
	Bool traited=true;	
	switch(iCmdP->GetCmdID())
		{
		case 52:
			result=CSTM(iCmdP);			
			break;
		default:
			traited=false;
		}
	if (!traited) 
		{
		result=CServiceSPC::Dispatch(iCmdP);
		}
	StopExecutingCmd();
	mCS.Unlock();
	return result;
}
//////////////////////////////////////////////////////////////////////////////////////////
void CServiceSPCCustomDll::OnConfigChange(int iConfigID, int iConfigEvent)
{
	mCS.Lock();	
	CConfigPOW* cfgPOW=(CConfigPOW*)GetConfig(CONFIG_POW);	
	switch(iConfigEvent)
		{
		case kCfgEventParamNChange:
			AppendVPMsg("Param N has changed");
			// Do whatever you want
			// For example set phone functionnality to 0
			cfgPOW->SetPhoneFunctionality(0);
		break;
		}	
	mCS.Unlock();
}
//////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////